# Ornatrix user-defined brush script
import ephere_ornatrix as ox

# User-defined brush name, shown in the drop-down list for brush selection. If not defined, the file name will be used
BrushName = 'Demo Move'

def Evaluate( guidesEditor, brushParameters, brushDirectionInObjectSpace, brushStrokeLength, strandIndices ):
	"""Applies a brush stroke to a list of strands.
	Parameters:
		-- guidesEditor - ox.IGuidesEditor object
		-- brushParameters - ox.BrushParameters object
		-- brushDirectionInObjectSpace - ox.Vector3 vector giving the direction of the brush stroke
		-- brushStrokeLength - float giving the length of the brush stroke
		-- strandIndices - a list of integer strand indices affected by the brush stroke
	"""
	# print( 'User-defined brush {0} acting with direction {1} and stroke length {2}\nStrand list: {3}\n'.format( BrushName, brushDirectionInObjectSpace, brushStrokeLength, strandIndices ) )

	hair = guidesEditor.GetEditableGuides()
	brushStrength = brushParameters.GetStrength() * brushStrokeLength

	for strandIndex in strandIndices:
		# Multiply strength by soft selection if only affecting selected strands
		strength = brushStrength if not brushParameters.affectSelectedOnly else brushStrength * hair.GetStrandChannelData( 0, strandIndex )
		delta = brushDirectionInObjectSpace * strength
		strandPoints = hair.GetStrandPoints( strandIndex, ox.CoordinateSpace.Object )
		strandPointCount = len( strandPoints )
		vertexWeights = guidesEditor.GetVertexWeights( strandIndex )
		for pointIndex in range( len( strandPoints ) ):
			strandPoints[pointIndex] += delta * vertexWeights[pointIndex]
		hair.SetStrandPoints( strandIndex, strandPoints, ox.CoordinateSpace.Object )
